/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : D/I and D/O
/* - Contents:  α׷ COMILX_DI_GetAll(..) COMILX_DO_PutAll(..) Լ 
/*    Ͽ D/I D/O 8ä ÿ Ʋϴ Դϴ.
/* - Remarks : 
/*     1.   COMI-LX101 带 ϴ  ۼǾϴ.
/*      ٸ 带 ϴ 쿡 COMILX_LoadDevice(...)Լ 
/*     ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasLX.h"

#define DEV_ID	COMI_LX201

void main (void)
{
	HANDLE hDevice;
	ULONG do_states=0, di_states;
	int di_each[8], i;

	if(!COMILX_LoadDll()){
		printf("ComidasLX.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMILX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMILX_UnloadDll();
		exit(0);
	}
	
	printf("DIO ׽Ʈ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();

	COMILX_DIO_SetUsage(hDevice, DI_ONLY);

	while(!kbhit())
	{
		//do_states = ~do_states;  //  D/O ä On/Off state  
		//COMILX_DO_PutAll (hDevice, do_states); // Put D/O  
		
		/* Get D/I and print on screen */
		di_states = COMILX_DI_GetAll(hDevice);
		/* di_states  ä state  ִ.         */
		/*  ä ¸    bit mask   */
		/*  ϸ ȴ.                                    */
		for(i=0; i<8; i++)
			di_each[i] = (di_states >> i) & 0x1;
		printf("States of DI0 ~ DI7 = %d %d %d %d %d %d %d %d\n",
				di_each[0], di_each[1], di_each[2], di_each[3],
				di_each[4], di_each[5], di_each[6], di_each[7]);
		Sleep(500);
	}

	
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
